/*

	FIFO Key Queue System
	by Mauro Grassi, 2007-2010

*/

#include "demo_board_hardware.h"
#include "keys.h"
#include "adc.h"
#include <math.h>
#include "main.h"

#pragma udata keydata

volatile unsigned char 	keyBuffer[KEY_BUFFER_SIZE];
volatile unsigned char	keyFull;
volatile unsigned char	keyGetPtr;
volatile unsigned char	keyPtr;
volatile unsigned int	keyCountTimer;
volatile unsigned int	keyPressedCount;
volatile unsigned char  keyState;
volatile unsigned char	keyInitialDebounce;

#pragma code usercode

unsigned char getKey(void)
{
	unsigned char g;
	
	if(keyFull>0)
    {
	    g=keyBuffer[keyGetPtr];
	    keyGetPtr++;
	    if(keyGetPtr>=KEY_BUFFER_SIZE)keyGetPtr=0;
		keyFull--;
	} 
	else 
	{
		g=NO_KEY;
	}
	return g;
}

void putKey(unsigned char k)
{
	/* returns the ir timeout */
	if(keyFull<KEY_BUFFER_SIZE)
   	{
		keyBuffer[keyPtr]=k;
		keyPtr++;
		if(keyPtr>=KEY_BUFFER_SIZE)keyPtr=0;
		keyFull++;
	}
}

void setKeysComparator(unsigned char on)
{
	if(on)
	{
		CM1CON=0x8D;
		PIR2bits.CM1IF=0;
		PIE2bits.CM1IE=1;
	}
	else
	{
		PIE2bits.CM1IE=0;
	}	
}

void setKeysTimer(unsigned char on)
{
	/* Controls TMR4 used for key presses */

	if(on)
	{			
		TMR4=0x01;
		T4CON=0x7F;
		PIR3bits.TMR4IF=0;
		PIE3bits.TMR4IE=1;		
	}
	else
	{
		T4CON=0;
		PIR3bits.TMR4IF=0;
		PIE3bits.TMR4IE=0;
	}
}

void powerKeys(unsigned char on)
{
	/* Power Up Or Down the System */
	
	PIE2bits.CM1IE=0;
	PIE3bits.TMR4IE=0;
	
	if(on)
	{
		#if(USE_PMDIS)
			PMDIS2bits.CMP1MD=0;
			PMDIS1bits.TMR4MD=0;	
		#endif
		IPR3bits.TMR4IP=KEYS_IP;	
		IPR2bits.CM1IP=KEYS_IP;
		PR4=0xFF;
		CVRCON=0xA3;
	}
	else
	{
		CVRCON=0x00;
		#if(USE_PMDIS)
			PMDIS2bits.CMP1MD=1;
			PMDIS1bits.TMR4MD=1;
		#endif	
	}
}

void clearKeys(void)
{
	keyFull=0;
	keyGetPtr=0;
	keyPtr=0;
	keyCountTimer=KEY_SCAN_PERIOD;
	keyPressedCount=0;
}

void initKeys(void)
{
 	clearKeys();
	powerKeys(1);
	setKeysTimer(0);
	setKeysComparator(1);
}
